#[cfg(test)]
use crate::{ast, codegen};

#[test]
fn test_builtin_conversion() {
    let input: Vec<ast::Builtin> = vec![
        ast::Builtin::Accounts,
        ast::Builtin::AddMod,
        ast::Builtin::ArrayLength,
        ast::Builtin::Balance,
        ast::Builtin::Blake2_128,
        ast::Builtin::Blake2_256,
        ast::Builtin::BlockCoinbase,
        ast::Builtin::BlockDifficulty,
        ast::Builtin::BlockHash,
        ast::Builtin::BlockNumber,
        ast::Builtin::Calldata,
        ast::Builtin::ExternalFunctionAddress,
        ast::Builtin::FunctionSelector,
        ast::Builtin::Gasleft,
        ast::Builtin::GasLimit,
        ast::Builtin::Gasprice,
        ast::Builtin::GetAddress,
        ast::Builtin::MinimumBalance,
        ast::Builtin::MulMod,
        ast::Builtin::Keccak256,
        ast::Builtin::Origin,
        ast::Builtin::Random,
        ast::Builtin::ReadAddress,
        ast::Builtin::ReadInt8,
        ast::Builtin::ReadInt16LE,
        ast::Builtin::ReadInt32LE,
        ast::Builtin::ReadInt64LE,
        ast::Builtin::ReadInt128LE,
        ast::Builtin::ReadInt256LE,
        ast::Builtin::ReadUint16LE,
        ast::Builtin::ReadUint32LE,
        ast::Builtin::ReadUint64LE,
        ast::Builtin::ReadUint128LE,
        ast::Builtin::ReadUint256LE,
        ast::Builtin::Ripemd160,
        ast::Builtin::Sender,
        ast::Builtin::Slot,
        ast::Builtin::Sha256,
        ast::Builtin::Signature,
        ast::Builtin::SignatureVerify,
        ast::Builtin::Timestamp,
        ast::Builtin::TombstoneDeposit,
        ast::Builtin::Value,
        ast::Builtin::WriteAddress,
        ast::Builtin::WriteInt8,
        ast::Builtin::WriteInt16LE,
        ast::Builtin::WriteInt32LE,
        ast::Builtin::WriteInt64LE,
        ast::Builtin::WriteInt128LE,
        ast::Builtin::WriteInt256LE,
        ast::Builtin::WriteUint16LE,
        ast::Builtin::WriteUint32LE,
        ast::Builtin::WriteUint64LE,
        ast::Builtin::WriteUint128LE,
        ast::Builtin::WriteUint256LE,
    ];

    let output: Vec<codegen::Builtin> = vec![
        codegen::Builtin::Accounts,
        codegen::Builtin::AddMod,
        codegen::Builtin::ArrayLength,
        codegen::Builtin::Balance,
        codegen::Builtin::Blake2_128,
        codegen::Builtin::Blake2_256,
        codegen::Builtin::BlockCoinbase,
        codegen::Builtin::BlockDifficulty,
        codegen::Builtin::BlockHash,
        codegen::Builtin::BlockNumber,
        codegen::Builtin::Calldata,
        codegen::Builtin::ExternalFunctionAddress,
        codegen::Builtin::FunctionSelector,
        codegen::Builtin::Gasleft,
        codegen::Builtin::GasLimit,
        codegen::Builtin::Gasprice,
        codegen::Builtin::GetAddress,
        codegen::Builtin::MinimumBalance,
        codegen::Builtin::MulMod,
        codegen::Builtin::Keccak256,
        codegen::Builtin::Origin,
        codegen::Builtin::Random,
        codegen::Builtin::ReadAddress,
        codegen::Builtin::ReadInt8,
        codegen::Builtin::ReadInt16LE,
        codegen::Builtin::ReadInt32LE,
        codegen::Builtin::ReadInt64LE,
        codegen::Builtin::ReadInt128LE,
        codegen::Builtin::ReadInt256LE,
        codegen::Builtin::ReadUint16LE,
        codegen::Builtin::ReadUint32LE,
        codegen::Builtin::ReadUint64LE,
        codegen::Builtin::ReadUint128LE,
        codegen::Builtin::ReadUint256LE,
        codegen::Builtin::Ripemd160,
        codegen::Builtin::Sender,
        codegen::Builtin::Slot,
        codegen::Builtin::Sha256,
        codegen::Builtin::Signature,
        codegen::Builtin::SignatureVerify,
        codegen::Builtin::Timestamp,
        codegen::Builtin::TombstoneDeposit,
        codegen::Builtin::Value,
        codegen::Builtin::WriteAddress,
        codegen::Builtin::WriteInt8,
        codegen::Builtin::WriteInt16LE,
        codegen::Builtin::WriteInt32LE,
        codegen::Builtin::WriteInt64LE,
        codegen::Builtin::WriteInt128LE,
        codegen::Builtin::WriteInt256LE,
        codegen::Builtin::WriteUint16LE,
        codegen::Builtin::WriteUint32LE,
        codegen::Builtin::WriteUint64LE,
        codegen::Builtin::WriteUint128LE,
        codegen::Builtin::WriteUint256LE,
    ];

    for (i, item) in input.iter().enumerate() {
        assert_eq!(codegen::Builtin::from(item), output[i]);
    }
}
