import expect from 'expect';
import { loadContract } from './setup';

describe('Deploy solang contract and test', function () {
    this.timeout(500000);

    it('events', async function () {
        const { contract } = await loadContract('events', 'events.abi');

        await new Promise((resolve) => {
            let first = true;
            let listenId = contract.addEventListener(async (ev) => {

                if (first) {
                    expect(Number(ev.args[0])).toEqual(102);
                    expect(ev.args[1]).toEqual(true);
                    expect(ev.args[2]).toEqual('foobar');

                    first = false;
                } else {
                    expect(Number(ev.args[0])).toEqual(500332);
                    expect(ev.args[1]).toEqual("0x41424344");
                    expect(ev.args[2]).toEqual("0xcafe0123");
                }

                await contract.removeEventListener(listenId);
                resolve(true);
            });

            contract.functions.test();
        });

        let res = await contract.functions.test({ simulate: true });

        expect(res.result).toBeNull();
        expect(res.events.length).toBe(2);

        let args = res.events[0].args;

        expect(Number(args[0])).toEqual(102);
        expect(args[1]).toEqual(true);
        expect(args[2]).toEqual('foobar');

        args = res.events[1].args;

        expect(Number(args[0])).toEqual(500332);
        expect(args[1]).toEqual("0x41424344");
        expect(args[2]).toEqual("0xcafe0123");
    });
});
