//! Official accounts and program ids

use serde::{Deserialize, Serialize};

pub mod main_router {
    use solana_program::pubkey::Pubkey;
    use std::str::FromStr;

    lazy_static::lazy_static! {
        pub static ref ID: Pubkey = {
            Pubkey::from_str(env!("MAIN_ROUTER_ID", "Please set MAIN_ROUTER_ID environment variable to the router-main program address")).unwrap()
        };
    }

    pub fn id() -> Pubkey {
        *ID
    }
}

pub mod main_router_admin {
    use solana_program::pubkey::Pubkey;
    use std::str::FromStr;

    lazy_static::lazy_static! {
        pub static ref ID: Pubkey = {
            Pubkey::from_str(env!("MAIN_ROUTER_ADMIN", "Please set MAIN_ROUTER_ADMIN environment variable to the router-main program admin")).unwrap()
        };
    }

    pub fn id() -> Pubkey {
        *ID
    }
}

pub mod zero {
    // ID that represents the unset Pubkey. This is to avoid passing Pubkey::default() which
    // is equal to system_program::id().
    // [14, 196, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    solana_program::declare_id!("zeRosMEYuuABXv5y2LNUbgmPp62yFD5CULW5soHS9HR");
}

pub const DAO_TOKEN_NAME: &str = "FARM_DAO";
pub const DAO_PROGRAM_NAME: &str = "FarmGovernance";
pub const DAO_MINT_NAME: &str = "FarmMintGovernance";
pub const DAO_CUSTODY_NAME: &str = "FarmCustodyGovernance";

#[derive(Serialize, Deserialize, Clone, Copy, Debug, Eq, PartialEq)]
pub enum ProgramIDType {
    System,
    ProgramsRef,
    VaultsRef,
    Vault,
    FarmsRef,
    Farm,
    PoolsRef,
    Pool,
    TokensRef,
    Token,
    MainRouter,
    Serum,
    Raydium,
    Saber,
    Orca,
    FundsRef,
    Fund,
}
