[![Latest Version]][crates.io] [![Documentation]] ![License]

A command line utility to copy UNIX domain socket datagrams from one socket to two other sockets.

Features:

* First destination socket is blocking.
* Second destination socket is buffered.
* Optionally drop oldest datagrams when buffer is full or block.
* Reconnect to buffered socket without dropping (internally) buffered datagrams.
* Configurable maximum datagram size and buffered socket buffer size.
* Optionally prefix datagrams with TAI64N or RFC3339 receive timestamps.

# Example usage

Forward copy of syslog messages to remote log server.

```bash
# Save syslog messages in a log file
socklog unix /var/run/syslog-local > /var/log/syslog &

# Forward syslog messages to remote log server
socklog unix -R /var/run/syslog-forward | nc -t prod.store.whatclinic.net 514 &

# Copy syslog messages for local storage and forwarding
umask 0000
socktee /dev/log /var/run/syslog-local /var/run/syslog-forward &

# Log a message
logger hello world
```

[crates.io]: https://crates.io/crates/socktee
[Latest Version]: https://img.shields.io/crates/v/socktee.svg
[Documentation]: https://docs.rs/socktee/badge.svg
[License]: https://img.shields.io/crates/l/socktee.svg
