use snowferris::{nanoid, rngs};

#[test]
fn generates_random_string() {
    fn random(length: usize) -> Vec<u8> {
        [2, 255, 0, 1]
            .iter()
            .cloned()
            .cycle()
            .take(length)
            .collect()
    }

    assert_eq!(nanoid::generate(random, &['a', 'b', 'c'], 4), "cabc");
}

#[test]
fn not_power_of_two() {
    let id: String = nanoid!(42, &nanoid::DEFAULT_CHARSET[0..62]);

    assert_eq!(id.len(), 42);
}

#[test]
#[should_panic]
fn bad_charset() {
    let charset: Vec<char> = (0..32_u8).cycle().map(|i| i as char).take(1000).collect();
    nanoid!(21, &charset);
}

#[test]
fn builder_len() {
    let builder = nanoid::NanoId::default();
    assert_eq!(builder.generate().len(), 21);
}

#[test]
fn builder_charset() {
    let builder = nanoid::NanoId::default().set_charset(['a'; 64]);

    assert_eq!(builder.generate(), "aaaaaaaaaaaaaaaaaaaaa")
}

#[test]
fn macro_default() {
    let id: String = nanoid!();

    assert_eq!(id.len(), 21);
}

#[test]
fn macro_length() {
    let id: String = nanoid!(12);

    assert_eq!(id.len(), 12);
}

#[test]
fn macro_charset() {
    let id: String = nanoid!(&nanoid::DEFAULT_CHARSET);

    assert_eq!(id.len(), 21);
}

#[test]
fn macro_combo() {
    let id: String = nanoid!(42, &nanoid::DEFAULT_CHARSET);

    assert_eq!(id.len(), 42);
}

#[test]
fn macro_full() {
    let id: String = nanoid!(4, &nanoid::DEFAULT_CHARSET, rngs::default);

    assert_eq!(id.len(), 4);
}
