{ pkgs }:

with pkgs;

# Configure your development environment.
#
# Documentation: https://github.com/numtide/devshell
devshell.mkShell {
  name = "iceberg";
  motd = ''
    Welcome to the snowferris (nix) devShell!
    If you see this message, it means your are inside the Nix shell.
    Command(s) available:
      - nixpkgs-fmt: format nix code
      - build-pkg: build 'snowferris' (cargo)
      - ci: run all CI tasks locally
  '';
  commands = [
    {
      name = "nixpkgs-fmt";
      help = "use this to format the Nix code";
      category = "fmt";
      package = "nixpkgs-fmt";
    }
    {
      name = "build-pkg";
      help = "build 'snowferris' (cargo)";
      category = "build";
      command = "cargo build --release";
    }
    {
      name = "ci";
      help = "run all CI tasks locally";
      category = "test";
      command = ''
        echo Running step 1 :: format
        cargo fmt --all -- --check

        echo Running step 2 :: clippy
        cargo clippy --all-targets --all-features -- -D warnings

        echo Running step 3 :: unit
        cargo test

        echo Running step 4 :: build
        cargo build --release
      '';
    }
  ];

  bash = {
    extra = ''
      export LD_INCLUDE_PATH="$DEVSHELL_DIR/include"
      export LD_LIB_PATH="$DEVSHELL_DIR/lib"
    '';
    interactive = '''';
  };

  env = [
    {
      name = "OPENSSL_DIR";
      value = "${openssl.bin}/bin";
    }

    {
      name = "OPENSSL_LIB_DIR";
      value = "${openssl.out}/lib";
    }

    {
      name = "OPENSSL_INCLUDE_DIR";
      value = "${openssl.out.dev}/include";
    }
  ];

  packages = [
    # Rust
    rust-bin.stable.latest.default
    rust-analyzer
    # rustfmt
    # clippy


    ### Others
    binutils
    clang
    nixpkgs-fmt
  ];
}
