use chrono::Utc;
use snowferris::snowflake::{Snowflake, SnowflakeData};

#[test]
fn generate() {
    let mut snowflake = Snowflake::default();
    let time = Utc::now().timestamp_millis();
    let data = SnowflakeData {
        timestamp: time,
        worker_id: 0,
        node_id: 1,
        sequence: 0,
    };
    assert_eq!(snowflake.assemble(data), snowflake.generate())
}

#[test]
fn assemble() {
    let snowflake = Snowflake::default();
    let data = SnowflakeData {
        timestamp: 1627979788243,
        worker_id: 0,
        node_id: 1,
        sequence: 1,
    };

    assert_eq!(6828242137746771969, snowflake.assemble(data));
}

#[test]
fn disassemble() {
    let snowflake = Snowflake::default();
    let data = SnowflakeData {
        timestamp: 1627979788243,
        worker_id: 0,
        node_id: 1,
        sequence: 1,
    };

    assert_eq!(data, snowflake.disassemble(6828242137746771969))
}
