use rand::{
    rngs::{SmallRng, StdRng},
    Rng, SeedableRng,
};

pub fn default(size: usize) -> Vec<u8> {
    let mut rng = StdRng::from_entropy();
    let mut result: Vec<u8> = vec![0; size];

    rng.fill(&mut result[..]);

    result
}

pub fn insecure(size: usize) -> Vec<u8> {
    let mut rng = SmallRng::from_entropy();
    let mut result = vec![0u8; size];

    rng.fill(&mut result[..]);

    result
}
