{
  description = "snowferris - Snowflake implementation for Rust";
  inputs = {
    nixpkgs.url = "github:NixOS/nixpkgs/master";
    flake-utils.url = "github:numtide/flake-utils";
    devshell.url = "github:numtide/devshell/master";

    # Rust dependencies
    rust.url = "github:oxalica/rust-overlay";
    naersk.url = "github:nmattia/naersk";
  };


  outputs = { self, nixpkgs, rust, naersk, flake-utils, devshell }:
    (
      flake-utils.lib.eachSystem [ "x86_64-linux" ] (system:
        let
          overlays = [
            (import rust)
            devshell.overlay

            naersk.overlay
          ];

          pkgs = import nixpkgs {
            inherit system overlays;
            # Makes the config pure as well. See <nixpkgs>/top-level/impure.nix:
            config = {
              allowBroken = true;
            };
          };
        in
        {
          devShell = import ./devshell.nix { inherit pkgs; };

          checks = { };
        }
      )
    );
}
