{ pkgs }:

with pkgs;

# Configure your development environment.
#
# Documentation: https://github.com/numtide/devshell
devshell.mkShell {
  name = "iceberg";
  motd = ''
    Welcome to the snowferris (nix) devShell!
    If you see this message, it means your are inside the Nix shell.
    Command(s) available:
      - nixpkgs-fmt: format nix code
  '';
  commands = [
    {
      name = "nixpkgs-fmt";
      help = "use this to format the Nix code";
      category = "fmt";
      package = "nixpkgs-fmt";
    }
  ];

  bash = {
    extra = ''
      export LD_INCLUDE_PATH="$DEVSHELL_DIR/include"
      export LD_LIB_PATH="$DEVSHELL_DIR/lib"
    '';
    interactive = '''';
  };

  env = [
    {
      name = "OPENSSL_DIR";
      value = "${openssl.bin}/bin";
    }

    {
      name = "OPENSSL_LIB_DIR";
      value = "${openssl.out}/lib";
    }

    {
      name = "OPENSSL_INCLUDE_DIR";
      value = "${openssl.out.dev}/include";
    }
  ];

  packages = [
    # Rust
    rust-bin.stable.latest.default
    rust-analyzer
    # rustfmt
    # clippy


    ### Others
    binutils
    clang
    glibc
    nixpkgs-fmt
  ];
}
