# How to contribute

Note: contributing implies licensing those contributions
under the terms of [LICENSE](../LICENSE), which is an ISC license.

## Opening issues

* Make sure you have a [sourcehut account](https://meta.sr.ht/)
* Make sure there is no open issue on the topic
* [Submit a new issue](https://todo.sr.ht/~boppy/snowferris)

## Submitting changes

* Format the commit messages in the following way:

  ```
  (topic, e.g chore, project, etc): (from -> to | fix (issue) | refactor | etc)

  (Motivation for change. Additional information.)
  ```

  For consistency, there should not be a period at the end of the commit message's summary line (the first line of the commit message).

  Examples:

  * chore: refactor .rustfmt.toml
  * project: fix #1 (use rustfmt)

## Writing good commit messages

In addition to writing properly formatted commit messages, it's important to include relevant information so other developers can later understand *why* a change was made. While this information usually can be found by digging code, mailing list/Discourse archives, todo discussions or upstream changes, it may require a lot of work.

For crate version bumps and such a one-line commit message is usually sufficient.

## Before sending a mail via mailing list

Check [mailing list etiquette](https://man.sr.ht/lists.sr.ht/etiquette.md) before sending the patch.

