// Copyright (C) 2019-2021 Aleo Systems Inc.
// This file is part of the snarkVM library.

// The snarkVM library is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// The snarkVM library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with the snarkVM library. If not, see <https://www.gnu.org/licenses/>.

/// Errors.
mod errors;
pub use errors::*;

/// Fiat-Shamir algebraic sponge RNG.
mod fiat_shamir_algebraic_sponge;
pub use fiat_shamir_algebraic_sponge::*;

/// Fiat-Shamir ChaCha RNG.
mod fiat_shamir_chacha;
pub use fiat_shamir_chacha::*;

/// Constraints for the Fiat-Shamir RNG.
mod fiat_shamir_algebraic_sponge_gadget;
pub use fiat_shamir_algebraic_sponge_gadget::*;

pub use snarkvm_algorithms::crypto_hash::poseidon::*;
pub use snarkvm_gadgets::algorithms::crypto_hash::poseidon::*;

/// Traits for the Fiat-Shamir RNG.
pub mod traits;
pub use traits::*;
