// Copyright (C) 2019-2021 Aleo Systems Inc.
// This file is part of the snarkVM library.

// The snarkVM library is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// The snarkVM library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with the snarkVM library. If not, see <https://www.gnu.org/licenses/>.

#[macro_use]
mod macros;

pub mod arithmetic;
pub use arithmetic::*;

pub mod bits;
pub use bits::*;

pub mod relational;
pub use relational::*;

pub mod uint_impl;
pub use uint_impl::*;

pub mod uint128;
pub use uint128::*;

#[cfg(test)]
mod tests;
