
<!----------------------------------------------------------------------------->
<!-------------------- THIS MARKDOWN FILE IS AUTOGENERATED -------------------->
<!----------------------------------------------------------------------------->

# snarkvm-curves

[![Crates.io](https://img.shields.io/crates/v/snarkvm-curves.svg?color=neon)](https://crates.io/crates/snarkvm-curves)
[![Authors](https://img.shields.io/badge/authors-Aleo-orange.svg)](https://aleo.org)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](./LICENSE.md)

## Overview
Aleo uses a tailored set of pairing-friendly elliptic curves to perform efficient proof generation and verification.

|                     |  Edwards BLS12  |     BLS12-377      |   Edwards BW6   |   BW6-761    |
|:------------------- |:---------------:|:------------------:|:---------------:|:------------:|
| Curve Type          | Twisted Edwards | Barreto-Lynn-Scott | Twisted Edwards | Brezing–Weng |
| Scalar Field Size   |    251 bits     |      253 bits      |    374 bits     |   377 bits   |
| Base Field Size     |    253 bits     |      377 bits      |    377 bits     |   761 bits   |
| G1 Compressed Size* |    32 bytes     |      48 bytes      |    48 bytes     |   96 bytes   |
| G2 Compressed Size* |       N/A       |      96 bytes      |       N/A       |   96 bytes   |

\* rounded to multiples of 8 bytes.

## Edwards BLS12
### Scalar Field

#### Modulus

##### Integer Representation
```ignore
2111115437357092606062206234695386632838870926408408195193685246394721360383
```

##### Hexadecimal Representation
```ignore
04aad957a68b2955982d1347970dec005293a3afc43c8afeb95aee9ac33fd9ff
```

##### U64 Representation (Little-Endian)
```ignore
[13356249993388743167, 5950279507993463550, 10965441865914903552, 336320092672043349]
```

#### Root of Unity

##### Integer Representation
```ignore
319259817323897909850357899558356952867916286821886696195104543796545181129
```

##### Hexadecimal Representation
```ignore
00b4b1d4c7e5e163b1af246173fdb411bdb82ac32901dcb9d289433ff2b7d5c9
```

##### U64 Representation (Little-Endian)
```ignore
[15170730761708361161, 13670723686578117817, 12803492266614043665, 50861023252832611]
```

### Base Field

#### Modulus

##### Integer Representation
```ignore
8444461749428370424248824938781546531375899335154063827935233455917409239041
```

##### Hexadecimal Representation
```ignore
12ab655e9a2ca55660b44d1e5c37b00159aa76fed00000010a11800000000001
```

##### U64 Representation (Little-Endian)
```ignore
[725501752471715841, 6461107452199829505, 6968279316240510977, 1345280370688173398]
```

#### Root of Unity

##### Integer Representation
```ignore
5928890464389279575069867463136436689218492512582288454256978381122364252082
```

##### Hexadecimal Representation
```ignore
0d1ba211c5cc349cd7aacc7c597248269a14cda3ec99772b3c3d3ca739381fb2
```

##### U64 Representation (Little-Endian)
```ignore
[4340692304772210610, 11102725085307959083, 15540458298643990566, 944526744080888988]
```

## BLS12-377
### Scalar Field

#### Modulus

##### Integer Representation
```ignore
8444461749428370424248824938781546531375899335154063827935233455917409239041
```

##### Hexadecimal Representation
```ignore
12ab655e9a2ca55660b44d1e5c37b00159aa76fed00000010a11800000000001
```

##### U64 Representation (Little-Endian)
```ignore
[725501752471715841, 6461107452199829505, 6968279316240510977, 1345280370688173398]
```

#### Root of Unity

##### Integer Representation
```ignore
5928890464389279575069867463136436689218492512582288454256978381122364252082
```

##### Hexadecimal Representation
```ignore
0d1ba211c5cc349cd7aacc7c597248269a14cda3ec99772b3c3d3ca739381fb2
```

##### U64 Representation (Little-Endian)
```ignore
[4340692304772210610, 11102725085307959083, 15540458298643990566, 944526744080888988]
```

### Base Field

#### Modulus

##### Integer Representation
```ignore
258664426012969094010652733694893533536393512754914660539884262666720468348340822774968888139573360124440321458177
```

##### Hexadecimal Representation
```ignore
01ae3a4617c510eac63b05c06ca1493b1a22d9f300f5138f1ef3622fba094800170b5d44300000008508c00000000001
```

##### U64 Representation (Little-Endian)
```ignore
[9586122913090633729, 1660523435060625408, 2230234197602682880, 1883307231910630287, 14284016967150029115, 121098312706494698]
```

#### Root of Unity

##### Integer Representation
```ignore
146552004846884389553264564610149105174701957497228680529098805315416492923550540437026734404078567406251254115855
```

##### Hexadecimal Representation
```ignore
00f3c1414ef58c54f95564f4cbc1b61fee086c1fe367c33776da78169a7f3950f1bd15c3898dd1af1c104955744e6e0f
```

##### U64 Representation (Little-Endian)
```ignore
[2022196864061697551, 17419102863309525423, 8564289679875062096, 17152078065055548215, 17966377291017729567, 68610905582439508]
```

## Edwards BW6
### Scalar Field

#### Modulus

##### Integer Representation
```ignore
32333053251621136751331591711861691692049189094364332567435817881934511297123972799646723302813083835942624121493
```

##### Hexadecimal Representation
```ignore
0035c748c2f8a21d58c760b80d94292763445b3e601ea271e1d75fe7d6eeb84234066d10f5d893814103486497d95295
```

##### U64 Representation (Little-Endian)
```ignore
[4684667634276979349, 3748803659444032385, 16273581227874629698, 7152942431629910641, 6397188139321141543, 15137289088311837]
```

#### Root of Unity

##### Integer Representation
```ignore
4045479506506707059583837976038047929582398534241670004595142696897457385453373366260645700405062319293168935493
```

##### Hexadecimal Representation
```ignore
0006ba8c867eaccf5f7e46bcdb07d0f4b2595092eedff5c5603102866827125373710874d7416d75a832273177b0e245
```

##### U64 Representation (Little-Endian)
```ignore
[12119792640622387781, 8318439284650634613, 6931324077796168275, 12851391603681523141, 6881015057611215092, 1893962574900431]
```

### Base Field

#### Modulus

##### Integer Representation
```ignore
258664426012969094010652733694893533536393512754914660539884262666720468348340822774968888139573360124440321458177
```

##### Hexadecimal Representation
```ignore
01ae3a4617c510eac63b05c06ca1493b1a22d9f300f5138f1ef3622fba094800170b5d44300000008508c00000000001
```

##### U64 Representation (Little-Endian)
```ignore
[9586122913090633729, 1660523435060625408, 2230234197602682880, 1883307231910630287, 14284016967150029115, 121098312706494698]
```

#### Root of Unity

##### Integer Representation
```ignore
146552004846884389553264564610149105174701957497228680529098805315416492923550540437026734404078567406251254115855
```

##### Hexadecimal Representation
```ignore
00f3c1414ef58c54f95564f4cbc1b61fee086c1fe367c33776da78169a7f3950f1bd15c3898dd1af1c104955744e6e0f
```

##### U64 Representation (Little-Endian)
```ignore
[2022196864061697551, 17419102863309525423, 8564289679875062096, 17152078065055548215, 17966377291017729567, 68610905582439508]
```

## BW6-761
### Scalar Field

#### Modulus

##### Integer Representation
```ignore
258664426012969094010652733694893533536393512754914660539884262666720468348340822774968888139573360124440321458177
```

##### Hexadecimal Representation
```ignore
01ae3a4617c510eac63b05c06ca1493b1a22d9f300f5138f1ef3622fba094800170b5d44300000008508c00000000001
```

##### U64 Representation (Little-Endian)
```ignore
[9586122913090633729, 1660523435060625408, 2230234197602682880, 1883307231910630287, 14284016967150029115, 121098312706494698]
```

#### Root of Unity

##### Integer Representation
```ignore
146552004846884389553264564610149105174701957497228680529098805315416492923550540437026734404078567406251254115855
```

##### Hexadecimal Representation
```ignore
00f3c1414ef58c54f95564f4cbc1b61fee086c1fe367c33776da78169a7f3950f1bd15c3898dd1af1c104955744e6e0f
```

##### U64 Representation (Little-Endian)
```ignore
[2022196864061697551, 17419102863309525423, 8564289679875062096, 17152078065055548215, 17966377291017729567, 68610905582439508]
```

### Base Field

#### Modulus

##### Integer Representation
```ignore
6891450384315732539396789682275657542479668912536150109513790160209623422243491736087683183289411687640864567753786613451161759120554247759349511699125301598951605099378508850372543631423596795951899700429969112842764913119068299
```

##### Hexadecimal Representation
```ignore
0122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f49d00000000008b
```

##### U64 Representation (Little-Endian)
```ignore
[17626244516597989515, 16614129118623039618, 1588918198704579639, 10998096788944562424, 8204665564953313070, 9694500593442880912, 274362232328168196, 8105254717682411801, 5945444129596489281, 13341377791855249032, 15098257552581525310, 81882988782276106]
```

#### Root of Unity

##### Integer Representation
```ignore
4949694554646618754694979731796049343519157116473313611064538181323940740652246024937990594760563456347661615224701433790977517130445602168702368961137022158607776438693094633929575070134431059866333103456550751572023511093377718
```

##### Hexadecimal Representation
```ignore
00d0f0a60a5be58cf9dfaa846595555f73a18e069ac04458d72c1d6f77d5f5c54d28be3a9f55c8155c81153f4906e9fec5a3614ac0b1d98484f3089e56574722be36179047832b0377738a6b6870f9598c391832e000739bf29a000000007ab6
```

##### U64 Representation (Little-Endian)
```ignore
[17481284903592032950, 10104133845767975835, 8607375506753517913, 13706168424391191299, 9580010308493592354, 14241333420363995524, 6665632285037357566, 5559902898979457045, 15504799981718861253, 8332096944629367896, 18005297320867222879, 58811391084848524]
```




## Contributing
 
### How to Update this README

This README is auto-generated during continuous integration.
To update this README, submit a pull request updating the appropriate Markdown file
in [documentation](./documentation) and the [configuration file](./documentation/config.json).

