//! Types and traits serving as the cryptographic primitives of `snapper-box`'s cryptosystem. <span
//! style="color:red">**HAZMAT**</span>
//!
//! # <span style="color:red">**DANGER**</span>
//!
//! This module deals in low level cryptographic details. It is advisable to not deal with this module
//! directly, and instead use a higher level API.

pub mod key;
pub mod types;

pub use key::{DerivedKey, EncryptedDerivedKey, EncryptedRootKey, Key, Nonce, RootKey};
pub use types::{CipherText, ClearText};
