![Gitlab pipeline status](https://img.shields.io/gitlab/pipeline-status/rust-community-matrix/snapper?branch=trunk&style=flat-square)
[![Crates.io](https://img.shields.io/crates/v/snapper-box?style=flat-square)](https://crates.io/crates/snapper-box)
[![Matrix](https://shields.io/badge/Matrix-%23snapper%3Acommunity.rs-green?logo=matrix&style=flat-square)](https://matrix.to/#/#snapper:community.rs)

# Snapper Box

<div align="center">
  <img src="https://gitlab.com/rust-community-matrix/snapper/-/raw/trunk/static/snapper.png" alt="Actually  a box turtle" width="350" height="350" />
</div>

## About

`snapper-box` provides the `CryptoBox` type, a LSM backed, encrypted, namespaced document store, for the
`snapper` ecosystem.

`CryptoBox` uses one file per namespace, with each namespace using its own key, derived from a
shared root key.

The root key is randomly generated, and is stored at rest encrypted with the argon2 derivation of a
user supplied password. Derived keys are derived using Blake3's key derivation mode.

XChaCha20 is used as the cipher, with Blake3 in HMAC mode used to provide integrity. The author
intentionally does not use poly1305, as he has a deep distrust of polynomial MACs, and very much
loves defense in depth.

## Getting Started

TODO

### Prerequisites

This project uses [nix](https://nixos.org/) for development. While it does use a [nix
flake](https://nixos.wiki/wiki/Flakes), the repository makes use of compatibility shims to allow
development and building without needing to be on `unstableNix`.

Once you [have nix installed](https://nixos.org/download.html), simply run, if you have flakes and
nix-command enabled:

``` shell
nix develop
```

or

``` shell
nix-shell
```

if you do not.

This project also has a `.evnrc` file, for use with direnv.

## Usage

TODO

## Contributing

Take a look at [`CONTRIBUTING.md`](../CONTRIBUTING.md)


## Documentation

Please take a look at the [`CHANEGLOG.md`](CHANGELOG.md) and the rustdoc.
