// Copyright 2020 MaidSafe.net limited.
//
// This SAFE Network Software is licensed to you under the MIT license <LICENSE-MIT
// http://opensource.org/licenses/MIT> or the Modified BSD license <LICENSE-BSD
// https://opensource.org/licenses/BSD-3-Clause>, at your option. This file may not be copied,
// modified, or distributed except according to those terms. Please review the Licences for the
// specific language governing permissions and limitations relating to use of the SAFE Network
// Software.

use log::{debug, error};
use sn_launch_tool::run;
pub use sn_launch_tool::run_with;
use std::process;

fn main() {
    env_logger::init();
    debug!("Launching Safe nodes...");

    if let Err(e) = run() {
        error!("sn_launch_tool error: {}", e);
        process::exit(1);
    }
}
