/*
 * Retriever
 */

use std::path::PathBuf;
use anyhow::Error;
use serde::Deserialize;

use crate::database_manager::DatabaseManager;

#[derive(Debug)]
pub struct Retriever {
    pub sn_grufs_path: PathBuf,
    pub database_manager: DatabaseManager,
}

#[derive(Deserialize, Debug)]
struct GithubApi {
    tag_name: String,
    tarball_url: String,
}

impl Retriever {
   
    pub async fn run(self) -> Result<(), Error> {
        self.database_manager.init()?;
        self.update_releases().await?; 
        
        Ok(())
    }

    pub async fn update_releases(self) -> Result<(), Error> {
        
        for repo_api_url in self.database_manager.get_repo_api_urls() { 

            let client = reqwest::Client::builder().user_agent("reqwest/0.11.3").build()?;
            let response = client
                .get(repo_api_url)
                .send()
                .await?;

            match response.status() {
            reqwest::StatusCode::BAD_REQUEST => println!(
                    "content-length:{:?} server:{:?}", 
                    response.headers().get(reqwest::header::CONTENT_LENGTH),
                    response.headers().get(reqwest::header::SERVER),
                ),
                status => println!("status: {}", status),
            }
            
            let ip = response
            .json::<GithubApi>()
            .await?;

            println!("{:?}", ip);
        }
        Ok(())
    }

}
