/*
 * Fiş prèsipal fa
 */

use directories::ProjectDirs;

#[path="retriever.rs"]
pub mod retriever;

#[path="database_manager.rs"]
pub mod database_manager;

#[tokio::main]
async fn main() -> Result<(), anyhow::Error> {

    if let Some(sn_grufs_dir) = ProjectDirs::from("safe","safenetwork_community","sn_grufs") {
        let sn_grufs_path = sn_grufs_dir.config_dir().to_path_buf().clone();         
        let mut sn_db_path = sn_grufs_path.clone();
        sn_db_path.push("version_check");
        let database_manager = database_manager::DatabaseManager::new(sn_db_path);
        match database_manager {
            Ok(database_manager) => {
                let retriever = retriever::Retriever{sn_grufs_path, database_manager};
                retriever.run().await?;
            },
            _ => {}
        }
    }

    Ok(())
}
