# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

### [2.9.2](https://github.com/maidsafe/sn_dbc/compare/v2.9.1...v2.9.2) (2021-12-04)

### [2.9.1](https://github.com/maidsafe/sn_dbc/compare/v2.9.0...v2.9.1) (2021-10-22)


### Bug Fixes

* **tests:** fix many-to-many test handling of invalid + valid proofs ([8bbf2e7](https://github.com/maidsafe/sn_dbc/commit/8bbf2e7130834d2889c334f5fa517b70b6fa4827))

## [2.9.0](https://github.com/maidsafe/sn_dbc/compare/v2.8.0...v2.9.0) (2021-10-21)


### Features

* add DbcPacket and DerivedKeySet ([1042a63](https://github.com/maidsafe/sn_dbc/commit/1042a634d85d76e8df9281f49d2f34a0cfd45394))

## [2.8.0](https://github.com/maidsafe/sn_dbc/compare/v2.7.1...v2.8.0) (2021-10-14)


### Features

* **client-writes-spentbook:** move reissue flow to SpentProofs ([fb7635c](https://github.com/maidsafe/sn_dbc/commit/fb7635c0a74cee9bb6202b220033da1b9da8ae5d))
* **spentproofs:** mint-repl is working again ([930b643](https://github.com/maidsafe/sn_dbc/commit/930b64319c8eb542abf62abe4fe3f28dfdb621c1))
* **spentproofs:** update benches ([482cb97](https://github.com/maidsafe/sn_dbc/commit/482cb9774a11fdef259b82535c28452d410048fa))

### [2.7.1](https://github.com/maidsafe/sn_dbc/compare/v2.7.0...v2.7.1) (2021-09-21)

## [2.7.0](https://github.com/maidsafe/sn_dbc/compare/v2.6.0...v2.7.0) (2021-09-16)


### Features

* add ReissueRequestBuilder to simplify aggregating dbc ownership proofs ([b0c3d5a](https://github.com/maidsafe/sn_dbc/commit/b0c3d5ae1b6e49534ddef75763141530cbace9dd))

## [2.6.0](https://github.com/maidsafe/sn_dbc/compare/v2.5.0...v2.6.0) (2021-09-14)


### Features

* **forced-one-time-keys:** dbc name is the owner ([0b4e9ef](https://github.com/maidsafe/sn_dbc/commit/0b4e9efef238ad5014f66211d99136f9e9ff8356))
* **forced-one-time-keys:** derive spending key from dbc hash ([1e1fbd1](https://github.com/maidsafe/sn_dbc/commit/1e1fbd168b57bed7515e5db93cc5148e2955dd3d))
* **forced-one-time-keys:** mint-repl works with dbc name change ([6ba078b](https://github.com/maidsafe/sn_dbc/commit/6ba078bb87cfff95428d15a2a65ec1a87d2a449f))
* **forced-one-time-keys:** remove blinded owner ([987b65e](https://github.com/maidsafe/sn_dbc/commit/987b65e8fb308d85c3d3c1e9430d6ede01af1313))
* **forced-one-time-keys:** update benchmarks ([1ea8cd3](https://github.com/maidsafe/sn_dbc/commit/1ea8cd3a0d17ca60443d23af8372deefe52fc37b))
* **forced-one-time-keys:** update mint-repl & benchmarks ([c8ae2e1](https://github.com/maidsafe/sn_dbc/commit/c8ae2e1edbd8d5a8d25657cfa3266e6774846ec0))
* **mint-repl:** more robust input handling ([51e9e43](https://github.com/maidsafe/sn_dbc/commit/51e9e43cd3ba078c4b70742dd31eb27ea7e7fd4e))

## [2.5.0](https://github.com/maidsafe/sn_dbc/compare/v2.4.2...v2.5.0) (2021-09-07)


### Features

* add DbcBuilder ([66fda04](https://github.com/maidsafe/sn_dbc/commit/66fda04e4589c4d97b105a1bb6d6ae25232f120b))
* add errors NoReissueShares and NoReissueTransaction ([f6aa707](https://github.com/maidsafe/sn_dbc/commit/f6aa7070ccdea830ebd536c52c34b2697ff7fc56))

### [2.4.2](https://github.com/maidsafe/sn_dbc/compare/v2.4.1...v2.4.2) (2021-08-19)


### Bug Fixes

* **bench:** fixes [#79](https://github.com/maidsafe/sn_dbc/issues/79) - bug in code to generate ownership proofs ([082e4bb](https://github.com/maidsafe/sn_dbc/commit/082e4bb9f3fd56a68408dd0c6c445540d2203659))
* **dkg:** use Outcome::index instead of hardcoding 0 ([0650b37](https://github.com/maidsafe/sn_dbc/commit/0650b378abed9e9c946c46db2013bc64aa6013e2))
* make dbc_content::AmountSecrets impl Copy ([5b5ef05](https://github.com/maidsafe/sn_dbc/commit/5b5ef059f5272f6e9df1ff3786487954c71b2fb5))

### [2.4.1](https://github.com/maidsafe/sn_dbc/compare/v2.4.0...v2.4.1) (2021-08-19)

## [2.4.0](https://github.com/maidsafe/sn_dbc/compare/v2.3.0...v2.4.0) (2021-08-18)


### Features

* **builder:** add fns for getting input/output sum and input hashes ([5eeae06](https://github.com/maidsafe/sn_dbc/commit/5eeae0623285242a7d91c68914f5649c559b499c))

## [2.3.0](https://github.com/maidsafe/sn_dbc/compare/v2.2.0...v2.3.0) (2021-08-17)


### Features

* **tx_builder:** introduce transaction builder pattern ([d0539a7](https://github.com/maidsafe/sn_dbc/commit/d0539a7a929a1cfc7027553c6d99da508faefa9f))


### Bug Fixes

* address CR comments - fix naming and spelling ([e796cfe](https://github.com/maidsafe/sn_dbc/commit/e796cfe7c96a87a27c7f50f1e24244a9145919c9))

## [2.2.0](https://github.com/maidsafe/sn_dbc/compare/v2.1.0...v2.2.0) (2021-08-13)


### Features

* add APIs that enable recipient to verify AmountSecrets match committed amount ([54776ee](https://github.com/maidsafe/sn_dbc/commit/54776eef6edf5973f5a543700a76292ecb0475d5))
* confidential transactions.  pedersen commitments + bulletproofs (range proofs) ([ee2623e](https://github.com/maidsafe/sn_dbc/commit/ee2623e9d30551bf731be0a3ead3969e39626376))

## [2.1.0](https://github.com/maidsafe/sn_dbc/compare/v2.0.0...v2.1.0) (2021-07-07)


### Features

* remove IntoIterator requirement on SpendBook trait ([c0ac6c2](https://github.com/maidsafe/sn_dbc/commit/c0ac6c2b215fc853d4d979bb68fd13d8862c92ea))

## [2.0.0](https://github.com/maidsafe/sn_dbc/compare/v1.7.0...v2.0.0) (2021-06-29)


### ⚠ BREAKING CHANGES

* updates to use blsstc

### Features

* use blsstc instead of threshold_crypto ([4044c27](https://github.com/maidsafe/sn_dbc/commit/4044c27aca4fdf03ec7e13a01e7cde4b9605e107))

## [1.7.0](https://github.com/maidsafe/sn_dbc/compare/v1.6.8...v1.7.0) (2021-06-24)


### Features

* add SpendBook::entries() to enforce type of Iterator values ([5a6d20e](https://github.com/maidsafe/sn_dbc/commit/5a6d20ec1a9d15fe363aab24a77d11e5db72c9c8))
* make SpendBook a trait so that implementer can decide how to store it ([287a341](https://github.com/maidsafe/sn_dbc/commit/287a34131da204a20d0a03a08bca0ac4e1acd0d9))
* return Result for SpendBook trait methods.  adds Error::SpendBook enum ([5bddb4c](https://github.com/maidsafe/sn_dbc/commit/5bddb4c346a140e2eb44f59641bc46dedcce94e5))

### [1.6.8](https://github.com/maidsafe/sn_dbc/compare/v1.6.7...v1.6.8) (2021-06-21)


### Bug Fixes

* **tests:** also match on the mapped errors ([df5c98c](https://github.com/maidsafe/sn_dbc/commit/df5c98c1b5ee3106c26b73642cefb50b0cd61d38))

### [1.6.7](https://github.com/maidsafe/sn_dbc/compare/v1.6.6...v1.6.7) (2021-06-17)

### [1.6.6](https://github.com/maidsafe/sn_dbc/compare/v1.6.5...v1.6.6) (2021-06-16)

### [1.6.5](https://github.com/maidsafe/sn_dbc/compare/v1.6.4...v1.6.5) (2021-06-15)

### [1.6.4](https://github.com/maidsafe/sn_dbc/compare/v1.6.3...v1.6.4) (2021-06-10)

### [1.6.3](https://github.com/maidsafe/sn_dbc/compare/v1.6.2...v1.6.3) (2021-06-09)

### [1.6.2](https://github.com/maidsafe/sn_dbc/compare/v1.6.1...v1.6.2) (2021-06-08)

### [1.6.1](https://github.com/maidsafe/sn_dbc/compare/v1.6.0...v1.6.1) (2021-06-07)

## [1.6.0](https://github.com/maidsafe/sn_dbc/compare/v1.5.0...v1.6.0) (2021-06-03)


### Features

* **mint:** replace ed25519 mint identities with BLS ([78baf59](https://github.com/maidsafe/sn_dbc/commit/78baf59d7f7e09c31ca083f459420ac15c847be5))


### Bug Fixes

* **bench:** update benchmarks to work with the new BLS keys ([e3da1fb](https://github.com/maidsafe/sn_dbc/commit/e3da1fb37dabc4b548ca819425065fd70f763f7a))
* **bls:** remove ed25519 dependency ([d46422a](https://github.com/maidsafe/sn_dbc/commit/d46422a5a6c9672ca805d7108e600ed32bfdf8ec))
* **mint:** replace mint keys with key sets; fixed size BLS indices ([3bd7e29](https://github.com/maidsafe/sn_dbc/commit/3bd7e29f7579414c884f8d092e0ef58debff514f))

## [1.5.0](https://github.com/maidsafe/sn_dbc/compare/v1.4.0...v1.5.0) (2021-06-02)


### Features

* **bench:** benchmark split and merge reissus ([852ac41](https://github.com/maidsafe/sn_dbc/commit/852ac41ddb46726268f81ff1c58bda5a52e6b9e3))

## [1.4.0](https://github.com/maidsafe/sn_dbc/compare/v1.3.1...v1.4.0) (2021-05-28)


### Features

* **owners:** blind owners in dbccontent ([f63454b](https://github.com/maidsafe/sn_dbc/commit/f63454bed3f3addfeecb9399422c17cd909c1e7f))

### [1.3.1](https://github.com/maidsafe/sn_dbc/compare/v1.3.0...v1.3.1) (2021-05-28)

## [1.3.0](https://github.com/maidsafe/sn_dbc/compare/v1.2.0...v1.3.0) (2021-05-27)


### Features

* redefine Hash as a struct so we can impl Display on it, and print as base64 ([b540203](https://github.com/maidsafe/sn_dbc/commit/b540203c5d988943662d91050d00939afd725cd4))

## [1.2.0](https://github.com/maidsafe/sn_dbc/compare/v1.1.0...v1.2.0) (2021-05-25)


### Features

* **mint:** take input hashes belonging to mint, in reissue method ([37b826b](https://github.com/maidsafe/sn_dbc/commit/37b826bf3a15d1a3215eb333544330edd7c7b83b))

## [1.1.0](https://github.com/maidsafe/sn_dbc/compare/v1.0.8...v1.1.0) (2021-05-19)


### Features

* **dbc_owner:** dbc_content now has an owner ([0eaede9](https://github.com/maidsafe/sn_dbc/commit/0eaede9640a51e51092dbde4881ce3e4676ae211))
* **dbc_owners:** make room in MintRequest for input ownership proof ([58f84af](https://github.com/maidsafe/sn_dbc/commit/58f84af22e4cb5494053eec65934c8a277ff6e0b))


### Bug Fixes

* **dbc_owner:** verify input owner proofs ([ffb5b66](https://github.com/maidsafe/sn_dbc/commit/ffb5b664dece2550b84d696a38fc18134689c74b))
* **fuzz_testing:** start fuzzing for ownership proofs ([b83e0eb](https://github.com/maidsafe/sn_dbc/commit/b83e0ebc9fece40c47ab38b9ab8240f22762b838))
* **owner:** depend on threshold_crypto instead of bls_dkg ([1fd6a7b](https://github.com/maidsafe/sn_dbc/commit/1fd6a7ba2a8871125cec4a469c37787d70b7eeaa))
* **owner:** tests are now fuzzing the owner field ([fd81ae0](https://github.com/maidsafe/sn_dbc/commit/fd81ae087575bcbbf7f6f4ece0a74f5bb4f8e52d))

### [1.0.8](https://github.com/maidsafe/sn_dbc/compare/v1.0.7...v1.0.8) (2021-05-11)

### [1.0.7](https://github.com/maidsafe/sn_dbc/compare/v1.0.6...v1.0.7) (2021-05-11)


### Bug Fixes

* **mint:** ensure mint request balances; validate output parents ([18835d6](https://github.com/maidsafe/sn_dbc/commit/18835d68f716ce3cdbdf5f6fbbd16580fe5bb5fa))
* **mint:** output parents are now checked ([93ae081](https://github.com/maidsafe/sn_dbc/commit/93ae081e027bc01b2f31112c1710da04108efdc1))
* **mint:** validate output numbering ([64f67df](https://github.com/maidsafe/sn_dbc/commit/64f67df94eaa6d1322514a2fdcd8bf0e33858246))

### [1.0.6](https://github.com/maidsafe/sn_dbc/compare/v1.0.5...v1.0.6) (2021-05-11)

### [1.0.5](https://github.com/maidsafe/sn_dbc/compare/v1.0.4...v1.0.5) (2021-05-06)

### [1.0.4](https://github.com/maidsafe/sn_dbc/compare/v1.0.3...v1.0.4) (2021-05-06)

### [1.0.3](https://github.com/maidsafe/sn_dbc/compare/v1.0.2...v1.0.3) (2021-05-06)

### [1.0.2](https://github.com/maidsafe/sn_dbc/compare/v1.0.1...v1.0.2) (2021-05-06)


### Bug Fixes

* **build:** remove references to vec{set,map} ([c937710](https://github.com/maidsafe/sn_dbc/commit/c9377107cbefd0dab5002ea75f1bc9fd8e3eec75))

### 1.0.1 (2021-05-06)

### 1.0.1 (2021-05-06)

### [0.1.0](https://github.com/maidsafe/sn_dbc/compare/v0.1.0...v0.1.0) (2021-05-06)

## 0.1.0 (2021-05-06)

* **sn_dbc:** initial implementation
