// Smoldot
// Copyright (C) 2019-2021  Parity Technologies (UK) Ltd.
// SPDX-License-Identifier: GPL-3.0-or-later WITH Classpath-exception-2.0

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#![cfg(test)]

#[test]
fn basic_works() {
    super::zstd_decode(&include_bytes!("./example-runtime")[..], 10 * 1024 * 1024).unwrap();
}

#[test]
fn limit_reached() {
    assert!(matches!(
        super::zstd_decode(&include_bytes!("./example-runtime")[..], 16 * 1024),
        Err(super::Error::TooLarge)
    ));
}

#[test]
fn invalid_data() {
    assert!(matches!(
        super::zstd_decode(&(0..2048).map(|_| 0xff).collect::<Vec<_>>(), 1024 * 1024),
        Err(super::Error::InvalidZstd)
    ));
}
