use crate::application::App;
use crossterm::event::{KeyCode, KeyEvent, KeyModifiers};

pub fn handle(key: KeyEvent, app: &mut App) {
    match key.code {
        KeyCode::Esc => app.stop(),

        KeyCode::Tab => {
            app.reset_test();
            app.change_to_test();
        }

        KeyCode::Char(c) => {
            if let KeyModifiers::CONTROL = key.modifiers {
                if c == 'c' {
                    app.stop();
                }
            }

            match c {
                'q' => app.stop(),
                's' => app.change_to_settings(),
                _ => (),
            }
        }

        _ => (),
    }
}
