use super::*;
use circle::{Circle, Point};

impl Welzl for Circle {
    type Point = Point;

    fn welzl(points: &[Self::Point]) -> Self {
        match points {
            [] => Circle::default(),
            [p1] => Circle::from_1_point(p1, 0.0),
            [p1, p2] => Circle::from_2_points(p1, p2),
            [p1, p2, p3] => Circle::from_3_points(p1, p2, p3),
            _ => {
                let mut points = points.to_vec();
                let mut center = points.pop().unwrap();
                let mut radius = 0.0;
                while !points.is_empty() {
                    let p = points.pop().unwrap();
                    let d = center.distance_to(&p);
                    if d > radius {
                        radius = d;
                        center = p;
                    }
                }
                Circle::from_1_point(&center, radius)
            }
        }
    }
    /// https://www.zhihu.com/question/266750532
    /// $$O(n^2\log(n)+n(\log(n))^2\log(\frac{D}{\varepsilon}))$$
    fn welzl_k(points: &[Self::Point], k: usize) -> Self {
        if k >= points.len() {
            Self::welzl(points)
        }
        else if k == 0 {
            Circle::default()
        }
        else if k == 1 {
            Circle::from_1_point(&points[0], 0.0)
        }
        else {
            todo!()
        }
    }
}
