use std::mem::MaybeUninit;

pub(crate) trait SpecWriteSlice<T>: Sized {
    fn spec_write_slice<'a>(this: &'a mut [MaybeUninit<T>], src: &[T]) -> &'a mut [T];
}

impl<T: Clone> SpecWriteSlice<T> for MaybeUninit<T> {
    default fn spec_write_slice<'a>(this: &'a mut [MaybeUninit<T>], src: &[T]) -> &'a mut [T] {
        MaybeUninit::write_slice_cloned(this, src)
    }
}
impl<T: Copy> SpecWriteSlice<T> for MaybeUninit<T> {
    fn spec_write_slice<'a>(this: &'a mut [MaybeUninit<T>], src: &[T]) -> &'a mut [T] {
        MaybeUninit::write_slice(this, src)
    }
}
