use crate::{SmallVec, SpecFromIterNested};
/// Specialization trait used for SmallVec::from_iter
///
/// ## The delegation graph:
///
/// ```text
/// +-------------+
/// |FromIterator |
/// +-+-----------+
///   |
///   v
/// +-+-------------------------------+  +---------------------+
/// |SpecFromIter                  +---->+SpecFromIterNested   |
/// |where I:                      |  |  |where I:             |
/// |  Iterator (default)----------+  |  |  Iterator (default) |
/// |  vec::IntoIter                  |  |  TrustedLen         |
/// +---------------------------------+  +---------------------+
/// ```
pub(crate) trait SpecFromIter<T, I> {
    fn from_iter(iter: I) -> Self;
}

impl<T, I, const N: usize> SpecFromIter<T, I> for SmallVec<T, N>
where
    I: Iterator<Item = T>,
{
    default fn from_iter(iterator: I) -> Self {
        SpecFromIterNested::from_iter(iterator)
    }
}
