pub(crate) trait ExtendWith<T> {
    fn next(&mut self) -> T;
    fn last(self) -> T;
}

pub(crate) struct ExtendElement<T>(pub(crate) T);
impl<T: Clone> ExtendWith<T> for ExtendElement<T> {
    fn next(&mut self) -> T {
        self.0.clone()
    }

    fn last(self) -> T {
        self.0
    }
}

pub(crate) struct ExtendDefault;
impl<T: Default> ExtendWith<T> for ExtendDefault {
    fn next(&mut self) -> T {
        Default::default()
    }

    fn last(self) -> T {
        Default::default()
    }
}

pub(crate) struct ExtendFunc<F>(pub(crate) F);
impl<T, F: FnMut() -> T> ExtendWith<T> for ExtendFunc<F> {
    fn next(&mut self) -> T {
        (self.0)()
    }

    fn last(mut self) -> T {
        (self.0)()
    }
}
