use crate::SmallVec;

impl<T, U, const A: usize, const B: usize> PartialEq<SmallVec<U, A>> for SmallVec<T, B>
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &SmallVec<U, A>) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const N: usize> PartialEq<Vec<U>> for SmallVec<T, N>
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &Vec<U>) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const N: usize> PartialEq<[U]> for SmallVec<T, N>
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &[U]) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const N: usize> PartialEq<&[U]> for SmallVec<T, N>
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &&[U]) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const N: usize> PartialEq<&mut [U]> for SmallVec<T, N>
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &&mut [U]) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const M: usize, const N: usize> PartialEq<[U; N]> for SmallVec<T, M>
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &[U; N]) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const M: usize, const N: usize> PartialEq<&[U; N]> for SmallVec<T, M>
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &&[U; N]) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const N: usize> PartialEq<SmallVec<U, N>> for [T]
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &SmallVec<U, N>) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const N: usize> PartialEq<SmallVec<U, N>> for &[T]
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &SmallVec<U, N>) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const N: usize> PartialEq<SmallVec<U, N>> for &mut [T]
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &SmallVec<U, N>) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const M: usize, const N: usize> PartialEq<SmallVec<U, M>> for [T; N]
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &SmallVec<U, M>) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const M: usize, const N: usize> PartialEq<SmallVec<U, M>> for &[T; N]
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &SmallVec<U, M>) -> bool {
        self[..] == other[..]
    }
}

impl<T, U, const M: usize, const N: usize> PartialEq<SmallVec<U, M>> for &mut [T; N]
where
    T: PartialEq<U>,
{
    fn eq(&self, other: &SmallVec<U, M>) -> bool {
        self[..] == other[..]
    }
}
