use std::ptr;

use crate::{ExtendElement, SmallVec};
pub(crate) trait SpecFromElem: Sized {
    fn spec_from_elem<const N: usize>(elem: Self, n: usize) -> SmallVec<Self, N>;
}

impl<T: Clone> SpecFromElem for T {
    default fn spec_from_elem<const N: usize>(elem: Self, n: usize) -> SmallVec<Self, N> {
        let mut v = SmallVec::with_capacity(n);
        v.extend_with(n, ExtendElement(elem));
        v
    }
}
impl SpecFromElem for i8 {
    #[inline]
    fn spec_from_elem<const N: usize>(elem: i8, n: usize) -> SmallVec<Self, N> {
        unsafe {
            let mut v = SmallVec::with_capacity(n);
            ptr::write_bytes(v.as_mut_ptr(), elem as u8, n);
            v.set_len(n);
            v
        }
    }
}

impl SpecFromElem for u8 {
    #[inline]
    fn spec_from_elem<const N: usize>(elem: u8, n: usize) -> SmallVec<Self, N> {
        unsafe {
            let mut v = SmallVec::with_capacity(n);
            ptr::write_bytes(v.as_mut_ptr(), elem, n);
            v.set_len(n);
            v
        }
    }
}
