use crate::SmallVec;

pub(crate) trait SpecFrom<T> {
    fn spec_from(slice: &[T]) -> Self;
}
impl<T, const N: usize> SpecFrom<T> for SmallVec<T, N>
where
    T: Clone,
{
    #[inline]
    default fn spec_from(slice: &[T]) -> SmallVec<T, N> {
        slice.iter().cloned().collect()
    }
}
impl<T, const N: usize> SpecFrom<T> for SmallVec<T, N>
where
    T: Copy,
{
    #[inline]
    fn spec_from(slice: &[T]) -> SmallVec<T, N> {
        SmallVec::from_slice(slice)
    }
}
