# This terraform project is meant for testing purposes only. All resources created
# should be for testing only and they could cease to exist on the Datadog side at any time.

terraform {
  required_version = "= 1.1.6"

  required_providers {
    datadog = {
      source  = "DataDog/datadog"
      version = "= 3.8.1"
    }

    google = {
      source  = "hashicorp/google"
      version = "= 4.9.0"
    }
  }

  backend "gcs" {
    bucket = "figure-terraform-production"
    prefix = "slo-converter/terraform"
  }
}

provider "datadog" {
  api_key = var.dd_api_key
  app_key = var.dd_app_key
}

provider "google" {
  project = "figure-shared-services"
}
