mod hcl;
mod yaml;

use anyhow::Result;
use clap::{ArgEnum, Parser};

use hcl::Resource;
use yaml::SloOuter;

// TODO add integration tests

/// Converts Figure SLO YAML to HCL
#[derive(Parser, Debug)]
#[clap(author, version, about, long_about = None)]
struct Cli {
    /// Path to YAML file
    #[clap(parse(from_os_str))]
    yaml: std::path::PathBuf,

    #[clap(long, arg_enum, default_value_t = Output::Stdout)]
    output: Output,
}

#[derive(Copy, Clone, Debug, Eq, PartialEq, PartialOrd, Ord, ArgEnum)]
enum Output {
    Stdout,
}

fn main() -> Result<()> {
    let cli = Cli::parse();

    if cli.yaml.is_dir() {
        return Err(anyhow::anyhow!("{:?} directories are not currently supported", &cli.yaml))
    } else if cli.yaml.is_file() {
        let contents = std::fs::read_to_string(cli.yaml)?;
        // Naively splits on --- delimiter. Parsing would fail on comments containing ---
        let yamls = contents.split(r"---");

        let mut resources = Vec::<Resource>::default();

        for yaml in yamls {
            let yaml: SloOuter = serde_yaml::from_str(yaml)?;

            for slo in yaml.slos {
                for sli in &slo.slis {
                    resources.push(sli.as_ref().into());
                }

                resources.push(slo.as_ref().into());
            }
        }

        // sort resources by name so output ordering is deterministic
        resources.sort_by(|a, b| {
            if a._type != b._type {
                a._type.cmp(&b._type)
            } else {
                a.name.cmp(&b.name)
            }
        });

        for resource in resources {
            println!("{}", resource);
        }
    } else {
        return Err(anyhow::anyhow!("{:?} does not exist", &cli.yaml))
    }

    Ok(())
}
