# slit

```
slit 0.0.1
slit is like `cut`, but (slightly) smarter.

It also is easier to use, because it has fewer options that most people want most of the time. If you're a `cut` whiz,
or your last name is Aho, Weinberger or Kernighan, this probably isn't for you.

# Differences from `cut`

For the most part, slit is like cut but more convenient defaults and additional functionality. However, there are a few
potential gotchas if migrating to it:

* There is no -s, --only-delimited option. By default, slit will not print any lines NOT containing the delimiter. This
is normally what you want, because otherwise you don't really know what you're going to get. Pass --print-undelimited to
get the default cut behavior of printing the whole line if it has no delimiters.

Pass `<file>` to read from a file, otherwise slit will read from STDIN.

USAGE:
    slit [FLAGS] [OPTIONS] --fields <include> [file]

FLAGS:
    -h, --help                 
            Prints help information

        --print-undelimited    
            Also print lines not containing the delimited character

    -V, --version              
            Prints version information

    -v, --verbose              
            Directory to use as the root of a new tmux session. Pass the flag multiple times to increase verbosity, up
            to a maximum of 3

OPTIONS:
    -d, --delimiter <delimiter>
            Delimiter to use instead of whitespace to split lines on when chunking them up into fields

    -F, --exclude <exclude>
            Exclude only these fields; also print any line that contains no delimiter character, unless the -s option is
            specified. Takes precedence over included fields selected with -f, --fields
    -f, --fields <include>
            Select only these fields; also print any line that contains no delimiter character, unless the -s option is
            specified
    -D, --output-delimiter <output-delimiter>
            Delimiter to use when printing the line, instead of the input delimiter.  Can be useful to transform a
            separated line into a line with a new separator.  them up into fields
    -n, --skip <skip>
            Number of lines to skip, from the beginning of the input. TODO: Make this accept a negative number to skip
            at the end [default: 0]

ARGS:
    <file>    
            Sum the values from a file

```

