# Contributing to slick

First and foremost, thank you! We appreciate that you want to contribute to
**slick**, your time is valuable, and your contributions mean a lot to us.

## Important!

By contributing to this project, you:

* Agree that you have authored 100% of the content
* Agree that you have the necessary rights to the content
* Agree that you have received the necessary permissions from your employer to make the contributions (if applicable)
* Agree that the content you contribute may be provided under the Project license(s)

## Getting started

**What does "contributing" mean?**

Creating an issue is the simplest form of contributing to a project. But there
are many ways to contribute, including the following:

- Updating or correcting documentation
- Feature requests
- Bug reports

**Showing support for slick**

Please keep in mind that open source software is built by people like you, who
spend their free time creating things the rest the community can use.

Don't have time to contribute? No worries, here are some other ways to show your
support for **slick**:

- star :star: the [project](https://github.com/nbari/slick)
- tweet your support for **slick**

## Issues

### Before creating an issue

Please try to determine if the issue is caused by an underlying library, and if
so, create the issue there. Sometimes this is difficult to know. We only ask
that you attempt to give a reasonable attempt to find out. Oftentimes the readme
will have advice about where to go to create issues.

Try to follow these guidelines

- **Avoid creating issues for implementation help**. It's much better for discoverability, SEO, and semantics - to keep the issue tracker focused on bugs and feature requests - to ask implementation-related questions on [stackoverflow.com][so]
- **Investigate the issue**:
- **Check the readme** - oftentimes you will find notes about creating issues, and where to go depending on the type of issue.
- Create the issue in the appropriate repository.

### Creating an issue

Please be as descriptive as possible when creating an issue. Give us the information we need to successfully answer your question or address your issue by answering the following in your issue:

- **version**: please note the version of **slick** are you using
- **extensions, plugins, helpers, etc** (if applicable): please list any extensions you're using
- **error messages**: please paste any error messages into the issue, or a [gist](https://gist.github.com/)

### Closing issues

The original poster or the maintainer's of **slick** may close an issue at
any time. Typically, but not exclusively, issues are closed when:

- The issue is resolved
- The project's maintainers have determined the issue is out of scope
- An issue is clearly a duplicate of another issue, in which case the duplicate issue will be linked
- A discussion has clearly run its course


## Pull Request Process

- Make sure the destination branch is **develop**, We are using git-flow.


[so]: http://stackoverflow.com/questions/tagged/slick
