//! Built-in reams to run sketches.
//!
//! A ream runs sketches inside an environment.

mod single;

#[cfg(feature = "ream_parallel")]
mod parallel;

#[cfg(feature = "ream_parallel")]
pub use parallel::*;

#[cfg(feature = "ream_single")]
pub use single::*;

use crate::env::*;

/// Trait for reams.
pub trait Ream {
    /// Environment ream will run in.
    type Env: Environment;

    /// Update all sketches managed by the ream.
    ///
    /// The `mill` is used to create new pages from the environment.
    fn update(&mut self, mill: &mut MillOf<Self::Env>) -> Status;
}
