use core::ops::AddAssign;

/// 2D point (x, y)
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub struct Point2<T> {
    /// x axis distance.
    pub x: T,

    /// y axis distance.
    pub y: T,
}

/// 2D size (width, height)
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub struct Size2<T> {
    /// Width component
    pub width: T,

    /// Height component
    pub height: T,
}

impl<T> AddAssign for Point2<T>
where
    T: AddAssign<T>,
{
    fn add_assign(&mut self, rhs: Self) {
        self.x += rhs.x;
        self.y += rhs.y;
    }
}

impl<T> AddAssign<&Point2<T>> for Point2<T>
where
    T: AddAssign<T> + Copy,
{
    fn add_assign(&mut self, rhs: &Point2<T>) {
        self.x += rhs.x;
        self.y += rhs.y;
    }
}
