/// Macro to create an environment.
#[macro_export]
macro_rules! env {
    {

    } => {
        pub struct Event(());

        pub struct Page(());

        pub struct Mill(());

        pub struct Env(());
    };
}

/// Macro to create environment for testing a single aspect.
#[macro_export]
macro_rules! env_for_aspect {
    {
        $aspect:ident
        {$($associated_types_code:tt)*}
        $({$($page_extra_code:tt)*})?
    } => {
        $crate::compose! {
            pub enum Events {
                #[part]
                Aspect($aspect::env_api::Events<TypesHolder>),
            }
        }

        $crate::compose! {
            #[derive(Default)]
            pub struct Page {
                #[part]
                pub aspect: $aspect::env_api::PageData<TypesHolder>,

                $($($page_extra_code)*)?
            }
        }

        pub struct Mill;

        pub struct Env(());

        pub struct TypesHolder;

        impl $aspect::env_api::AssociatedTypes for TypesHolder {
            $($associated_types_code)*
        }

        impl $aspect::env_api::EnvAssociatedTypes for Env {
            type AssociatedTypesHolder = TypesHolder;
        }

        impl $crate::Environment for Env {
            type Mill = Mill;

            fn run<F>(self, _func: F)
            where
                F: FnMut(&mut Self::Mill) -> $crate::Status,
            {
                panic!("A single aspect environment does not allow running.")
            }
        }

        impl $crate::Mill for Mill {
            type Page = Page;

            fn new_page(&mut self) -> Self::Page {
                Page::default()
            }
        }

        impl $crate::Page for Page {
            type Event = Events;

            fn start_group(&mut self) {}

            fn end_group(&mut self) {}

            fn next_event_in_group(&mut self) -> Option<Self::Event> {
                None
            }

            fn before_event(&mut self, _event: &Self::Event) {}

            fn finish_event(&mut self, _event: Self::Event) {}

            fn status(&self) -> $crate::Status {
                $crate::Status::Stop
            }
        }
    };
}

pub use env_for_aspect;
