//! Minimal environment for use in examples and tests.

use crate::env;

/// Minimal events.
pub enum Events {}

/// Minimal page.
#[derive(Default)]
pub struct Page;

/// Minimal mill.
pub struct Mill;

/// Minimal environment.
pub struct Env;

impl env::Environment for Env {
    type Mill = Mill;

    fn run<F>(self, mut func: F)
    where
        F: FnMut(&mut Self::Mill) -> env::Status,
    {
        while let env::Status::Continue = func(&mut Mill) {
            core::hint::spin_loop();
        }
    }
}

impl env::Mill for Mill {
    type Page = Page;

    fn new_page(&mut self) -> Self::Page {
        Page::default()
    }
}

impl env::Page for Page {
    type Event = Events;

    fn start_group(&mut self) {}

    fn end_group(&mut self) {}

    fn next_event_in_group(&mut self) -> Option<Self::Event> {
        None
    }

    fn before_event(&mut self, _event: &Self::Event) {}

    fn finish_event(&mut self, _event: Self::Event) {}

    fn status(&self) -> env::Status {
        env::Status::Stop
    }
}
