use super::mode::Mode;

/// Context for converting a value into a shape
pub struct Context<R, C> {
    /// Fill of shape
    pub fill: C,

    /// Border color of shape
    pub stroke: C,

    /// Border width of shape
    pub weight: R,

    /// Mode for rectangle like shapes
    pub rectangle_mode: Mode,

    /// Mode for ellipse like shapes
    pub ellipse_mode: Mode,

    // pub translation: Point2<R>,
    
    /// Current rotation
    pub rotation: R,

    // pub scale: Float,
}
