# Sketchbook

Interactive visual applications in Rust.

## Notice

This crate is still in early development.
It is fully usable as is, but more features are expected to be added.
Additionally, the documentation is not currently complete.

Currently the only developed environment is `sketchbook-wgpu`.
It is not a requirement to use `sketchbook-wgpu`, but not using it will require implementing a custom environment.

## Project Goals

Goals:

- Bring the easy to use API style of Processing and p5.js to Rust.
- Be usable by people new to Rust.
- Reduce time for user to implement an idea with visuals and interaction.
- Allow using Sketchbook on any target Rust supports.
- High performance in debug builds.
- Zero dependencies by default.
- Extendable by the user or other crates.
- NO GLOBAL STATE!

Non-goals:

- Perfectly recreate the Processing or p5.js API.
- Support every use case of a graphics library.
- Re-implement functionality from other crates where they could be optional dependencies (i.e. not a monolithic crate).
- Be a framework. All framework like APIs should have a matching individual use version.
- Be itself a graphics backend.

## Environments

Currently only `sketchbook-wgpu` exists as a ready to use environment for Sketchbook.
Future plans include a WASM environment, other native backends, and embedded environments (i.e. like Arduino).
