# Creating The Tiles From C++

What we'll do is take the list of tiles declared in the .60 language, duplicate it, and shuffle it.
We'll do so by accessing the `memory_tiles` property through the Rust code. For each top-level property,
a getter and a setter function is generated - in our case `get_memory_tiles` and `set_memory_tiles`.
Since `memory_tiles` is an array in the `.60` language, it is represented as a [`std::shared_ptr<sixtyfps::Model>`](https://sixtyfps.io/docs/cpp/api/classsixtyfps_1_1model).
We can't modify the model generated by the .60, but we can extract the tiles from it, and put it
in a [`sixtyfps::VectorModel`](https://sixtyfps.io/docs/cpp/api/classsixtyfps_1_1vectormodel) which inherits from `Model`.
`VectorModel` allows us to make modifications and we can use it to replace the static generated model.

We modify the main function like so:

```cpp
{{#include main_tiles_from_cpp.cpp:main}}
```

Running this gives us a window on the screen that now shows a 4 by 4 grid of rectangles, which can show or obscure
the icons when clicking. There's only one last aspect missing now, the rules for the game.

<video autoplay loop muted playsinline src="https://sixtyfps.io/blog/memory-game-tutorial/creating-the-tiles-from-rust.mp4"></video>
