**In memory serializing to disk Database. 
Mimics FifthDatabase(C++ / boost)
SixthDatabase is for Rust using Serde.**

---



## Requirements

```rust
[dependencies]
sixth_database = "*"
```

# **Usage**

------

## 

```rust
// more examples at https://gitlab.com/Wepwawet/sixthdatabase/-/tree/master/examples

extern crate sixth_database;
use sixth_database::Database;
use std::sync::{Arc, Mutex};
use std::thread;
use std::time::Duration;

// this example is intended to be ran multiple times, each time it is ran
// an entry is saved into the database and re-loaded when the program starts again
fn main() {
    let example: Arc<Mutex<Database<String>>> = Database::new("example_db_name");
    // let example = Database::new("example_db_name"); // also acceptable

    {
        let mut test = example.lock().expect("Failed to obtain 6db lock");
        test.data.push("testing 123".to_string());

        for datum in &test.data {
            println!("{}", datum);
        }

        // after the program has been ran 10 times, the 'database' will contain 10 entires. this then clears the contents of the vector, and database
        if test.data.len() > 10
        {
            test.data.clear();
        }

        std::mem::drop(test);
    }

    // if the program terminates immediately in main, threads appear to exit too quickly to save data
    thread::sleep(Duration::from_secs(1));
}


```





## Getting help

File a ticket at https://gitlab.com/Wepwawet/sixthdatabase/issues/new


If you use this and want your project to be featured here, open a ticket.



[C++ FifthDatabase](https://gitlab.com/Wepwawet/fifthdatabase)
