pub struct CACAO<S: Ser, V: Sig> {
    pub h: Header,
    pub p: Message,
    pub s: Signature<V::SignatureMetadata>,
}

pub struct Type(pub Ser, pub Sig);

pub struct Header<T> {
    pub t: T,
}

pub struct Signature<M = ()> {
    pub m: Option<M>,
    pub s: Vec<u8>,
}

pub trait Ser {
    const ID: &'static str;
}

pub trait Sig {
    const ID: &'static str;
    type SignatureMetadata = ();
}

pub struct Message {
    pub aud: Host,
    pub exp: Option<String>,
    pub iat: String,
    pub iss: String,
    pub nbf: Option<String>,
    pub uri: UriAbsoluteString,
    pub nonce: String,
    pub version: Version,
    pub requestId: Option<String>,
    pub resources: Vec<UriString>,
    pub statement: String,
}
