# SIRP

 This is a novelty mathematics crate that computes large factorials, k-factorials and (sequential) interval residue products up to (2^64-1)!. As well as faster-than-naive evaluation of there factorization and logarithms, independently of direct computation.
 
 It currently uses the [number-theory](https://github.com/JASory/ENT) library for arbitrary-precision arithmetic. 
 
 Note that fast\_log and fast\_factor have no guarantee of accuracy and are only useful for estimating near-incomputably large values. Fast\_log however performs generally quite well, with less than a digit of error in most cases. Fast\_factor however uses an estimate based on geometric series and simple division, which is quite poor in most cases, except for 1-factorials, and even then not exact. 
 
 Example of computing a single-factorial, a double-factorial and a SIRP
 
 ```rust
    use sirp::Sirp;
    
    // the factorial, aka the product of all numbers in the interval 1..100
    
    let  factorial_100 = Sirp::new(1,100,1,0).unwrap() ; 
    
    // the double factorial 100!!
    
    let double_100 = Sirp::new(1,100,2,0).unwrap() ;
    
      // the product of all odd numbers in the interval 1..100
      
    let double_odd_100 = Sirp::new(1,100,2,1).unwrap();
    
     // the product of all odd numbers in the interval 50..100
     
    let sirp_50_100 = Sirp::new(50,100,2,1).unwrap();
    
     // generate the digits to display later
     
    factorial_100.gen_digits();
    
    // compute the logarithm near-exactly
    
     double_100.log(10);
     
    // compute the  exact factorization
    
    double_100_odd.factor()
    
    // constant-time (i.e nanosecond) estimate of logarithm 
    
    double_odd_100.fast_log(10);
    
    // Estimate of factor
    
    sirp_50_100.fast_factor()
      
    
     
 ```

 Etc. . . Sirp is a more generalized approach that includes the factorials, intervals of factorials, and k-factorials
 See [Factorials and SIRPs](https://rust-cas.org/fun/misc/sirp.html) for a further discussion of this crate and some of the algorithms used. 
