#[macro_export]
macro_rules! css {
    ($body:literal) => {{
        // Register globally once.
        static IS_REGISTERED: std::sync::atomic::AtomicBool =
            std::sync::atomic::AtomicBool::new(false);
        let was_registered = IS_REGISTERED.swap(true, std::sync::atomic::Ordering::Relaxed);

        let (class, css) = sir::compile_style_item!($body);

        if !was_registered {
            sir::CSS_COLLECTION.register(css.to_string());
        }

        class
    }};
}
