// Copyright 2022 Daniel Mowitz
//
// This file is part of sing.
//
// sing is free software: you can redistribute it and/or modify it 
// under the terms of the GNU Affero General Public License 
// as published by the Free Software Foundation, 
// either version 3 of the License, or (at your option) any later version.
//
// sing is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
// See the GNU Affero General Public License for more details.
// 
// You should have received a copy of the GNU Affero General Public License
//  along with sing. If not, see <https://www.gnu.org/licenses/>. 

use std::{str::FromStr, error::Error};

use proc_macro2::TokenStream;
use serde::{Serialize, Deserialize};

/// Wraps the proc_macro2 Tokenstream type,
/// so it can be serialized and deserialized.
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct TokenStreamWrapper(String);

impl TokenStreamWrapper {
	 pub fn new(stream: TokenStream) -> Self {
		  Self(stream.to_string())
	 }
	 pub fn get_inner(&self) -> Result<TokenStream, Box<dyn Error>> {
		  Ok(TokenStream::from_str(&self.0.clone())?)
	 }
}
