// Copyright 2022 Daniel Mowitz
//
// This file is part of sing.
//
// sing is free software: you can redistribute it and/or modify it 
// under the terms of the GNU Affero General Public License 
// as published by the Free Software Foundation, 
// either version 3 of the License, or (at your option) any later version.
//
// sing is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
// See the GNU Affero General Public License for more details.
// 
// You should have received a copy of the GNU Affero General Public License
//  along with sing. If not, see <https://www.gnu.org/licenses/>. 

use std::{error::Error};

pub use callobj::CallObj;

#[macro_use] extern crate lalrpop_util;
extern crate lalrpop;

mod callobj;

lalrpop_mod!(fun_parser);

/// Default message serialization function for the sing_loop macro.
pub fn callobj_to_string(o: CallObj) -> Result<String, Box<dyn Error>> {
	 Ok(o.to_string())
}

/// Default message deserialization function for the sing_loop macro.
pub fn callobj_from_string(s: String) -> Result<CallObj, Box<dyn Error>> {
	 // TODO: This should use a "?", but for some reason the error references s
	 Ok(fun_parser::CallParser::new().parse(&s).unwrap())
}

#[cfg(test)]
mod tests {
    use crate::fun_parser;


	 #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }

	 #[test]
    fn parser_parses() {
		  let test_str = "Trait>Fun>1 arg1 arg2 arg3"; 
        assert!(fun_parser::CallParser::new()
            .parse(test_str)
					 .is_ok());
    }

	 #[test]
	 fn parser_parses_correctly() {
		  let test_str: &str = "Trait>Fun>1 arg1 arg2 arg3";
		  println!("[{}]",
					  fun_parser::CallParser::new()
					  .parse(test_str).unwrap()
		  );
		  assert!(format!( "{}", 
				fun_parser::CallParser::new()
				.parse(test_str).unwrap()
		  ) == test_str);
	 }
}
