#[cfg(test)]
mod tests {
    use crate::pseudo_rand;
    use crate::entropy_rand;
    
    #[test]
    fn test_pseudo() {
        pseudo_rand();
    }

    #[test]
    fn test_entropy() {
        entropy_rand();
    }
}

// tries until a pseudo-random number is returned
pub fn pseudo_rand() -> u64 {
    use std::arch::x86_64::_rdrand64_step;
    let mut rand_num: u64 = 0;

    if unsafe { _rdrand64_step(&mut rand_num) } == 1 {
        rand_num
    } else {
        pseudo_rand()
    }
}

// tries once to get a pseudo-random number and returns None if failed
pub fn try_pseudo_rand() -> Option<u64> {
    use std::arch::x86_64::_rdrand64_step;
    let mut rand_num: u64 = 0;

    if unsafe { _rdrand64_step(&mut rand_num) } == 1 {
        Some(rand_num)
    } else {
        None
    }
}

// tries until a entropy-random number is returned
pub fn entropy_rand() -> u64 {
    use std::arch::x86_64::_rdseed64_step;
    let mut rand_seed: u64 = 0;

    if unsafe { _rdseed64_step(&mut rand_seed) } == 1 {
        rand_seed
    } else {
        entropy_rand()
    }
}

// tries once to get an entropy-random number and returns None if failed
pub fn try_entropy_rand() -> Option<u64> {
    use std::arch::x86_64::_rdseed64_step;
    let mut rand_seed: u64 = 0;

    if unsafe { _rdseed64_step(&mut rand_seed) } == 1 {
        Some(rand_seed)
    } else {
        None
    }
}