#[cfg(test)]
mod tests {
    use crate::pseudo_rand;
    use crate::entropy_rand;
    
    #[test]
    fn test_pseudo() {
        pseudo_rand();
    }

    #[test]
    fn test_entropy() {
        entropy_rand();
    }
}

pub fn pseudo_rand() -> u64 {
    use std::arch::x86_64::_rdrand64_step;
    let mut rand_num: u64 = 0;

    if unsafe { _rdrand64_step(&mut rand_num) } == 1 {
        rand_num
    } else {
        pseudo_rand()
    }
}

pub fn entropy_rand() -> u64 {
    use std::arch::x86_64::_rdseed64_step;
    let mut rand_seed: u64 = 0;

    if unsafe { _rdseed64_step(&mut rand_seed) } == 1 {
        rand_seed
    } else {
        entropy_rand()
    }
}