#[test]
fn test() {
	#[derive(Debug,PartialEq,serde_derive::Deserialize)]
	struct Test {
		numbers: Vec<i32>,
		strings: Vec<String>,
	}

	let s = b"
numbers: # Before
	1
	2
# between
	3 # inline
	# after
strings:
	#before
	foo
	foo bar # inline
	not-a-key: foo
";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <Test as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, Test{
		numbers: vec![1, 2, 3],
		strings: vec!["foo".into(), "foo bar".into(), "not-a-key: foo".into()],
	})

}

#[test]
fn multi_line() {
	#[derive(Debug,PartialEq,serde_derive::Deserialize)]
	struct Test {
		strings: Vec<String>,
		dicts: Vec<std::collections::HashMap<String, u8>>,
	}

	let s = b"
strings:
	single-line

	:
		multi-line
		string!

	single-line
dicts:
	:
		foo: 1
		bar: 2
	:
		baz: 3
";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <Test as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, Test{
		strings: vec!["single-line".into(), "multi-line\nstring!".into(), "single-line".into()],
		dicts: vec![
			std::array::IntoIter::new([("foo".into(), 1), ("bar".into(), 2)]).collect(),
			std::array::IntoIter::new([("baz".into(), 3)]).collect(),
		],
	})

}
