#[test]
fn test() {
	#[derive(Debug,PartialEq,serde_derive::Deserialize)]
	struct Inner {
		xyz: String,
		a: u8,
	}

	#[derive(Debug,PartialEq,serde_derive::Deserialize)]
	struct Outer {
		a: Inner,
		abc: Inner,
	}

	let s = b"
# Useless comment
a:
	xyz: foo # Inline
	a: 9
	# After
abc: # Before indent.
	a: 0
	# Between
	xyz:1
";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <Outer as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, Outer{
		a: Inner{xyz: "foo".into(), a: 9},
		abc: Inner{xyz: "1".into(), a: 0},
	})
}

#[test]
fn int_keys() {
	let s = b"
1: foo
2: bar
-1: zop
";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <std::collections::BTreeMap<i8, String> as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, std::array::IntoIter::new([
		(-1, "zop".into()),
		(1, "foo".into()),
		(2, "bar".into()),
	]).collect())
}

#[test]
fn option_keys() {
	let s = b"
any: 3
2: 1
none: 2
";

	let mut d = crate::Deserializer::from(buffered_reader::Memory::new(s));
	let t = <std::collections::BTreeMap<Option<String>, u8> as serde::de::Deserialize>::deserialize(&mut d).unwrap();
	assert_eq!(t, std::array::IntoIter::new([
		(None, 2),
		(Some("any".into()), 3),
		(Some("2".into()), 1),
	]).collect())
}
